
<?php $__env->startSection('content'); ?> 
<!-- Header start --> 
<?php echo $__env->make('includes.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?> 
<!-- Header end --> 
<!-- Inner Page Title start --> 
<?php echo $__env->make('includes.inner_page_title', ['page_title'=>__('Pay with Razorpay')], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?> 
<!-- Inner Page Title end -->
<div class="listpgWraper">
    <div class="container">
        <div class="row"> 
            <?php if(Auth::guard('company')->check()): ?>
                <?php echo $__env->make('includes.company_dashboard_menu', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            <?php else: ?>
                <?php echo $__env->make('includes.user_dashboard_menu', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            <?php endif; ?>
            <div class="col-md-9 col-sm-8">
                <div class="userccount">
                    <div class="row">
                        <div class="col-md-5">
                            <img src="<?php echo e(asset('/')); ?>images/razorpay-logo.png" alt="" />
                            <div class="razorpckinfo">
                                <h5><?php echo e(__('Invoice Details')); ?></h5>
                                <div class="pkginfo"><?php echo e(__('Package')); ?>: <strong><?php echo e($package->package_title); ?></strong></div>
                                <div class="pkginfo"><?php echo e(__('Price')); ?>: <strong><?php echo e($siteSetting->default_currency_code); ?><?php echo e($package->package_price); ?></strong></div>
                                <div class="pkginfo">
                                    <?php echo e(__('Package Duration')); ?>: <strong><?php echo e($package->package_num_days); ?> <?php echo e(__('Days')); ?></strong>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-7">
                            <div class="formpanel">
                                <?php echo $__env->make('flash::message', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                <h5><?php echo e(__('Razorpay Payment Details')); ?></h5>
                                <?php echo Form::open(['method' => 'post', 'route' => 'razorpay.order.package', 'id' => 'razorpay-form']); ?>

                                <?php echo e(Form::hidden('package_id', $package_id)); ?>

                                <div class="formrow">
                                    <button id="rzp-button" class="btn btn-primary">
                                        <?php echo e(__('Pay with Razorpay')); ?> 
                                        <i class="fa fa-arrow-circle-right" aria-hidden="true"></i>
                                    </button>
                                </div>
                                <?php echo Form::close(); ?>

                                <hr>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php echo $__env->make('includes.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>
<?php $__env->startPush('styles'); ?>
<style type="text/css">
    .userccount p { text-align: left !important; }
</style>
<?php $__env->stopPush(); ?>
<?php $__env->startPush('scripts'); ?>
<script src="https://checkout.razorpay.com/v1/checkout.js"></script>
<script>
    var options = {
        "key": "<?php echo e(config('services.razorpay.key')); ?>",
        "amount": "<?php echo e($package->package_price * 100); ?>", // Amount in paisa
        "currency": "<?php echo e($siteSetting->default_currency_code); ?>",
        "name": "<?php echo e($siteSetting->site_name); ?>",
        "description": "<?php echo e(__('Payment for')); ?> <?php echo e($package->package_title); ?>",
        "image": "<?php echo e(asset('images/logo.png')); ?>",
        "handler": function (response) {
            // Add Razorpay response data to the form and submit
            var form = document.getElementById('razorpay-form');
            var paymentId = document.createElement('input');
            paymentId.setAttribute('type', 'hidden');
            paymentId.setAttribute('name', 'razorpay_payment_id');
            paymentId.setAttribute('value', response.razorpay_payment_id);
            form.appendChild(paymentId);
            form.submit();
        },
        "prefill": {
            "name": "<?php echo e(Auth::user()->name ?? ''); ?>",
            "email": "<?php echo e(Auth::user()->email ?? ''); ?>",
        },
        "theme": {
            "color": "#F37254"
        }
    };

    var rzp1 = new Razorpay(options);
    document.getElementById('rzp-button').onclick = function (e) {
        e.preventDefault();
        rzp1.open();
    };
</script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\xampp8\htdocs\jobsportal\resources\views/order/pay_with_razorpay.blade.php ENDPATH**/ ?>